package ru.yandex.mail.so.logger;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.mail.so.logger.config.ConfigFactory;
import ru.yandex.mail.so.logger.config.LogStorageConfig;
import ru.yandex.mail.so.logger.config.MdsLogStorageConfig;
import ru.yandex.mail.so.logger.config.NullLogStorageConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum LogStorageType implements ConfigFactory<LogStorageConfig> {
    NULL {
        @Override
        public LogStorageConfig createConfig(final IniConfig config, final String name, final LogStorageConfig defaults)
        {
            return NullLogStorageConfig.INSTANCE;
        }

        @Override
        public LogRecordsContext<LogRecordContext> createLogRecordsStorageContext(
            final LogRecordsContext<LogRecordContext> context,
            final JsonObject json)
            throws JsonException
        {
            return new NullLogRecordsStorageContext(context, json);
        }
    },
    MDS {
        @Override
        public LogStorageConfig createConfig(final IniConfig config, final String name, final LogStorageConfig defaults)
            throws ConfigException
        {
            MdsLogStorageConfig mDefaults = null;
            if (defaults instanceof MdsLogStorageConfig) {
                mDefaults = (MdsLogStorageConfig) defaults;
            }
            return new MdsLogStorageConfig(config, name, mDefaults);
        }

        @Override
        public LogRecordsContext<LogRecordContext> createLogRecordsStorageContext(
            final LogRecordsContext<LogRecordContext> context,
            final JsonObject json)
            throws JsonException
        {
            return new MdsLogRecordsStorageContext(context, json);
        }
    };

    public abstract LogRecordsContext<LogRecordContext> createLogRecordsStorageContext(
        final LogRecordsContext<LogRecordContext> context,
        final JsonObject json) throws JsonException;
}
