package ru.yandex.mail.so.logger;

import com.google.common.collect.ImmutableList;

/**
 * MongoDB's error types.
 * See all error codes here: https://github.com/mongodb/mongo/blob/master/src/mongo/base/error_codes.yml.
 */
public enum MongoResultType {
    SUCCESS("success", 0),
    EXECUTION_TIMEOUT("execution-timeout", 50, 262, 290),
    DUPLICATE_KEY("duplicate-key", 11000, 11001, 12582),
    NOT_PRIMARY("not-primary", 10107, 13435, 10058),
    RECOVERING("recovering", 11600, 11602, 13436, 189, 91),
    NETWORK("network", 6, 7, 89, 202, 317, 9001),
    OTHER("other-errors");

    private final String signalName;
    private final ImmutableList<Integer> codes;

    MongoResultType(final String signalName, Integer... codes) {
        this.signalName = signalName;
        this.codes = ImmutableList.copyOf(codes);
    }

    public String signalName() {
        return signalName;
    }

    public ImmutableList<Integer> codes() {
        return codes;
    }

    public static MongoResultType fromCode(final int code) {
        for (MongoResultType errorType : values()) {
            if (errorType.codes.contains(code)) {
                return errorType;
            }
        }
        return OTHER;
    }
}
