package ru.yandex.mail.so.logger;

import java.util.logging.Logger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.mail.so.logger.config.AuxiliaryStorageConfig;
import ru.yandex.mail.so.logger.config.ImmutableAuxiliaryStorageConfig;

public class NullAuxiliaryStorage implements AuxiliaryStorage {
    final SpLogger spLogger;
    final ImmutableAuxiliaryStorageConfig config;
    private final String storageName;

    public NullAuxiliaryStorage(
        final SpLogger spLogger,
        final ImmutableAuxiliaryStorageConfig config,
        final String storageName)
        throws LogStorageException
    {
        this.spLogger = spLogger;
        this.config = config;
        this.storageName = storageName;
    }

    @Override
    public AuxiliaryStorageType type() {
        return AuxiliaryStorageType.NULL;
    }

    @Override
    public BatchSaver<BasicRoutedLogRecordProducer, AuxiliaryStorageConfig> batchSaver() {
        return null;
    }

    @Override
    public String name() {
        return BatchLogSaver.NULL;
    }

    @Override
    public Logger logger() {
        return spLogger.logger();
    }

    @Override
    public AuxiliaryStorageConfig config() {
        return config;
    }

    public String storageName() {
        return storageName;
    }

    @Override
    public TimeFrameQueue<Long> batchSize() {
        return null;
    }

    @Override
    public TimeFrameQueue<Long> batchCapacity() {
        return null;
    }

    @Override
    public void save(
        final BasicRoutedLogRecordProducer logRecordProducer,
        final ProxySession session,
        final FutureCallback<Void> callback)
    {
        callback.completed(null);
    }

    @Override
    public boolean saveBatch(Batch<BasicRoutedLogRecordProducer> batch, Logger logger) {
        return true;
    }

    @Override
    public LogsConsumerRecordsBatch currentBatch() {
        return null;
    }

    @Override
    public boolean batchIsEmpty() {
        return true;
    }

    @Override
    public LogsConsumerRecordsBatch resetBatch() {
        return null;
    }
}
