package ru.yandex.mail.so.logger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.parser.uri.CgiParams;

public class NullLogRecordContext implements LogRecordContext {
    private final SpLogger spLogger;
    private final CgiParams params;
    private final String service;
    private final LogStorageType storageType;
    private String logRecord;
    private final Route route;
    private int offset;
    private int logSize;
    private int byteOffset;
    private int logBytesSize;
    private Logger logger;

    public NullLogRecordContext(
        final SpLogger spLogger,
        final ProxySession session,
        final LogStorageType storageType,
        final String logRecord,
        final Route route)
    {
        this.spLogger = spLogger;
        this.params = session.params();
        this.storageType = storageType;
        this.logRecord = logRecord;
        this.route = route;
        service = service();
        offset = logSize = byteOffset = logBytesSize = 0;
        logger = session.logger();
    }

    public NullLogRecordContext(final LogContext logContext, final JsonMap record) {
        spLogger = logContext.spLogger();
        route = logContext.route();
        storageType = logContext.storageType();
        service = service();
        offset = logSize = byteOffset = logBytesSize = 0;
        params = new CgiParams(init(record));
        logger = spLogger.logger();
    }

    @Override
    public SpLogger spLogger() {
        return spLogger;
    }

    @Override
    public String name() {
        return BatchLogSaver.NULL;
    }

    @Override
    public CgiParams params() {
        return params;
    }

    @Override
    public String service() {
        return service;
    }

    @Override
    public LogStorageType storageType() {
        return storageType;
    }

    @Override
    public LogRecordsHandlerType handlerType() {
        return LogRecordsHandlerType.NULL;
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public long prefix() {
        return 0L;
    }

    @Override
    public String logRecord() {
        return logRecord;
    }

    @Override
    public void setLogRecord(final String logRecord) {
        this.logRecord = logRecord;
    }

    @Override
    public Map<String, List<String>> init(final JsonMap jsonMap) {
        return new HashMap<>();
    }

    @Override
    public void init(final CgiParams params) {
    }

    @Override
    public void setStorageKey(final String storageKey) {
    }

    @Override
    public void setOffset(final int byteOffset) {
    }

    @Override
    public void setByteOffset(final int byteOffset) {
    }

    @Override
    public long ttl() {
        return 0L;
    }

    @Override
    public void setTTL(final long ttl) {
    }

    @Override
    public Route route() {
        return route;
    }

    @Override
    public String storageKey() {
        return null;
    }

    @Override
    public int offset() {
        return offset;
    }

    @Override
    public int logSize() {
        return logSize;
    }

    @Override
    public int byteOffset() {
        return byteOffset;
    }

    @Override
    public int logBytesSize() {
        return logBytesSize;
    }
}
