package ru.yandex.mail.so.logger;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.uri.CgiParams;

public class NullLogRecordsContext implements LogRecordsContext<LogRecordContext> {
    protected final SpLogger spLogger;
    protected final ProxySession session;
    protected final String service;
    protected final LogStorageType storageType;
    protected final List<LogRecordContext> records;
    protected final int limit;
    protected final Route route;

    public NullLogRecordsContext(
        final SpLogger spLogger,
        final ProxySession session,
        final LogStorageType storageType,
        final Route route)
    {
        this.spLogger = spLogger;
        this.session = session;
        this.storageType = storageType;
        this.route = route;
        String svc = session.params().getOrNull(SearchParam.SERVICE.paramName());
        service = svc != null && !svc.isEmpty() ? svc : spLogger.config().indexingQueueName();
        records = new ArrayList<>();
        int maxDocsCount;
        try {
            maxDocsCount = session.params().getInt(SearchParam.LIMIT.paramName(), DEFAULT_SEARCH_DOCS_LIMIT);
        } catch (BadRequestException e) {
            maxDocsCount = DEFAULT_SEARCH_DOCS_LIMIT;
        }
        limit = maxDocsCount;
    }

    @Override
    public SpLogger spLogger() {
        return spLogger;
    }

    @Override
    public ProxySession session() {
        return session;
    }

    @Override
    public CgiParams params() {
        return session.params();
    }

    @Override
    public String service() {
        return service;
    }

    @Override
    public List<LogRecordContext> records() {
        return records;
    }

    @Override
    public int limit() {
        return limit;
    }

    @Override
    public Route route() {
        return route;
    }

    @Override
    public void init(final JsonObject json) throws JsonException {
    }

    @Override
    public LogRecordsHandlerType handlerType() {
        return LogRecordsHandlerType.NULL;
    }

    @Override
    public LogStorageType storageType() {
        return storageType;
    }
}
