package ru.yandex.mail.so.logger;

import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.mail.so.logger.config.ImmutableLogRecordsHandlerConfig;
import ru.yandex.parser.config.ConfigException;

public class NullLogRecordsHandler extends AbstractLogRecordsHandler {
    public NullLogRecordsHandler(
        final ImmutableLogRecordsHandlerConfig config,
        final SpLogger spLogger,
        final String path)
        throws ConfigException
    {
        super(config, spLogger, path);
    }

    @Override
    public Map<String, Long> getSearchIndexRequest(final ProxySession session) throws BadRequestException {
        return null;
    }

    @Override
    public void searchData(
        final LogRecordsContext<?> context,
        final Map<String, Long> queries,
        final FutureCallback<JsonObject> callback)
    {
        callback.completed(null);
    }
}
