package ru.yandex.mail.so.logger;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.uri.CgiParams;

public class NullLogRecordsStorageContext implements LogRecordsContext<LogRecordContext> {
    protected final SpLogger spLogger;
    protected final ProxySession session;
    protected final String service;
    protected final List<LogRecordContext> records;
    protected final int limit;
    protected final LogRecordsHandlerType handlerType;
    protected final Route route;

    public NullLogRecordsStorageContext(final LogRecordsContext<LogRecordContext> context, final JsonObject json)
        throws JsonException
    {
        spLogger = context.spLogger();
        session = context.session();
        this.route = context.route();
        String svc = session.params().getOrNull(SearchParam.SERVICE.paramName());
        service = svc != null && !svc.isEmpty() ? svc : spLogger.config().indexingQueueName();
        records = new ArrayList<>();
        limit = context.limit();
        handlerType = context.handlerType();
        init(json);
    }

    @Override
    public SpLogger spLogger() {
        return spLogger;
    }

    @Override
    public ProxySession session() {
        return session;
    }

    @Override
    public CgiParams params() {
        return session.params();
    }

    @Override
    public String service() {
        return service;
    }

    @Override
    public List<LogRecordContext> records() {
        return records;
    }

    @Override
    public int limit() {
        return limit;
    }

    @Override
    public Route route() {
        return route;
    }

    @Override
    public LogRecordsHandlerType handlerType() {
        return handlerType;
    }

    @Override
    public LogStorageType storageType() {
        return LogStorageType.NULL;
    }
}
