package ru.yandex.mail.so.logger;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.mail.so.logger.config.LogStorageConfig;

public class NullLogStorage extends AbstractLogStorage<LogRecordContext> {
    private final SpLogger spLogger;

    public NullLogStorage(final SpLogger spLogger, final String storageName) {
        super(storageName, null);
        this.spLogger = spLogger;
    }

    public static NullLogStorage instance(final SpLogger spLogger) {
        return new NullLogStorage(spLogger, NULL);
    }

    @Override
    public Logger logger() {
        return spLogger.logger();
    }

    @Override
    public TimeFrameQueue<Long> batchSize() {
        return null;
    }

    @Override
    public TimeFrameQueue<Long> batchCapacity() {
        return null;
    }

    @Override
    public void get(
        final LogRecordsContext<LogRecordContext> context,
        final FutureCallback<List<LogRecordsBatch<LogRecordContext, LogStorageConfig>>> callback)
    {
        callback.completed(null);
    }

    @Override
    public void save(
        final LogRecordContext context,
        final ProxySession session,
        final FutureCallback<Void> callback)
    {
        callback.completed(null);
    }

    @Override
    public void remove(final ProxySession session, final FutureCallback<Void> callback) {
        callback.completed(null);
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void close() {
    }

    @Override
    public long ttl() {
        return 0L;
    }

    @Override
    public void setTTL(final long ttl) {
    }

    @Override
    public BatchSaver<LogRecordContext, LogStorageConfig> batchSaver() {
        return null;
    }

    @Override
    public boolean saveBatch(final Batch<LogRecordContext> batch, final Logger logger) {
        return false;
    }

    @Override
    public Batch<LogRecordContext> resetBatch() {
        return null;
    }

    @Override
    public Batch<LogRecordContext> currentBatch() {
        return null;
    }

    @Override
    public LogStorageType type() {
        return LogStorageType.NULL;
    }
}
