package ru.yandex.mail.so.logger;

import java.io.IOException;
import java.util.logging.Logger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.mail.so.logger.config.RulesStatDatabaseConfig;

public class NullRulesStatDatabase<P extends RoutedLogRecordProducer> extends AbstractRulesStatDatabase<P>
{
    private final HttpProxy<?> httpProxy;

    public NullRulesStatDatabase(
        final HttpProxy<?> httpProxy,
        final String clientName)
    {
        super(clientName, null);
        this.httpProxy = httpProxy;
    }

    public NullRulesStatDatabase<P> instance(final HttpProxy<?> httpProxy) {
        return new NullRulesStatDatabase<>(httpProxy, NULL);
    }

    @Override
    public RulesStatDatabaseType type() {
        return RulesStatDatabaseType.NULL;
    }

    @Override
    public Logger logger() {
        return httpProxy.logger();
    }

    @Override
    public TimeFrameQueue<Long> batchSize() {
        return null;
    }

    @Override
    public TimeFrameQueue<Long> batchCapacity() {
        return null;
    }

    @Override
    public void save(
        final P logRecordProducer,
        final ProxySession session,
        final FutureCallback<Void> callback)
    {
        callback.completed(null);
    }

    @Override
    public BatchSaver<P, RulesStatDatabaseConfig<P>> batchSaver() {
        return null;
    }

    @Override
    public boolean saveBatch(final Batch<P> batch, final Logger logger) {
        return false;
    }

    @Override
    public Batch<P> resetBatch() {
        return null;
    }

    @Override
    public Batch<P> currentBatch() {
        return null;
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void close() {
    }
}
