package ru.yandex.mail.so.logger;

import java.util.logging.Logger;

import com.mongodb.lang.NonNull;
import org.apache.http.concurrent.FutureCallback;

public class OperationSubscriberWithCallback<T> extends OperationSubscriber<T> {
    protected final FutureCallback<Void> callback;
    protected final Logger logger;

    public OperationSubscriberWithCallback(
        final FutureCallback<Void> callback,
        final String opName,
        final Logger logger)
    {
        super(opName);
        this.callback = callback;
        this.logger = logger;
    }

    @Override
    public void hookOnError(@NonNull final Throwable t) {
        super.hookOnError(t);
        logger.warning("Operation '" + opName + "' failed: " + t);
        callback.failed(errors.get(errors.size() - 1));
    }

    @Override
    public void hookOnCancel() {
        super.hookOnCancel();
        callback.cancelled();
    }

    @Override
    public void hookOnComplete() {
        super.hookOnComplete();
        logger.info("Operation '" + opName + "' onComplete: result = " + result());
        callback.completed(null);
    }
}
