package ru.yandex.mail.so.logger;

import ru.yandex.mail.so.logger.config.ConfigFactory;
import ru.yandex.mail.so.logger.config.MongoRulesStatDatabaseConfig;
import ru.yandex.mail.so.logger.config.NullRulesStatDatabaseConfig;
import ru.yandex.mail.so.logger.config.RulesStatDatabaseConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum RulesStatDatabaseType implements ConfigFactory<RulesStatDatabaseConfig<BasicRoutedLogRecordProducer>> {
    NULL {
        @Override
        public RulesStatDatabaseConfig<BasicRoutedLogRecordProducer> createConfig(
            final IniConfig config,
            final String name,
            final RulesStatDatabaseConfig<BasicRoutedLogRecordProducer> defaults)
            throws ConfigException
        {
            return new NullRulesStatDatabaseConfig(config, name, defaults);
        }
    },
    MONGODB {
        @Override
        public RulesStatDatabaseConfig<BasicRoutedLogRecordProducer> createConfig(
            final IniConfig config,
            final String name,
            final RulesStatDatabaseConfig<BasicRoutedLogRecordProducer> defaults)
            throws ConfigException
        {
            MongoRulesStatDatabaseConfig mDefaults = null;
            if (defaults instanceof MongoRulesStatDatabaseConfig) {
                mDefaults = (MongoRulesStatDatabaseConfig) defaults;
            }
            return new MongoRulesStatDatabaseConfig(config, name, mDefaults);
        }
    },
    PG {
        @Override
        public RulesStatDatabaseConfig<BasicRoutedLogRecordProducer> createConfig(
            final IniConfig config,
            final String name,
            final RulesStatDatabaseConfig<BasicRoutedLogRecordProducer> defaults)
            throws ConfigException
        {
            // TODO: implement this functionality as needed
            return null;
        }
    }
}
