package ru.yandex.mail.so.logger;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.mail.so.logger.config.RulesStatDatabaseConfig;
import ru.yandex.mail.so.logger.config.RulesStatDatabasesConfig;
import ru.yandex.mail.so.logger.config.RulesStatDatabasesOperatorConfig;

public interface RulesStatDatabasesOperator<P extends RoutedLogRecordProducer> {
    /**
     * Get config for operations with rules statistics related databases
     *
     * @return config for operations with rules statistics related databases
     */
    RulesStatDatabasesConfig<P> rulesStatDatabasesConfig();

    /**
     * Get rules statistics related databases clients
     *
     * @return rules statistics related databases clients
     */
    Map<String, RulesStatDatabase<P>> rulesStatDatabases();

    /**
     * Get rules statistics database's client by its config name
     *
     * @param dbName name of rules statistics database's client from the config
     *
     * @return rules statistics database's client by its config name
     */
    default RulesStatDatabase<P> rulesStatDatabase(final String dbName) {
        return rulesStatDatabases().get(dbName);
    }

    /**
     * Create mongodb's clients
     *
     * @param rulesStatDatabasesOperatorConfig config for the rules statistics related databases' operators
     * @param httpProxy server where new clients will be registered
     * @return map with mongodb clients according to its config names
     */
    default Map<String, RulesStatDatabase<P>> prepareClients(
        final RulesStatDatabasesOperatorConfig<P> rulesStatDatabasesOperatorConfig,
        final HttpProxy<?> httpProxy)
    {
        Map<String, RulesStatDatabase<P>> rulesStatDatabasesClients = new HashMap<>();
        rulesStatDatabasesClients.put(
            NullRulesStatDatabase.NULL,
            new NullRulesStatDatabase<>(httpProxy, NullRulesStatDatabase.NULL));
        for(Map.Entry<String, ? extends RulesStatDatabaseConfig<P>> entry
                : rulesStatDatabasesOperatorConfig.rulesStatDatabasesConfig().rulesStatDatabases().entrySet())
        {
            String name = entry.getKey();
            httpProxy.logger().info("Configuring DB client <" + name + ">");
            RulesStatDatabaseConfig<P> config = entry.getValue();
            rulesStatDatabasesClients.put(name, config.createClient(httpProxy, rulesStatDatabasesOperatorConfig, name));
        }
        return rulesStatDatabasesClients;
    }
}
