package ru.yandex.mail.so.logger;

import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.ServerException;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.http.util.nio.AsyncStringConsumer;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonType;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.proxy.universal.PlainUniversalSearchProxyRequestContext;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;
import ru.yandex.stater.ImmutableStaterConfig;
import ru.yandex.stater.RequestInfo;
import ru.yandex.stater.RequestsStater;
import ru.yandex.util.timesource.TimeSource;

public class SearchBackendProxyHandler extends RequestsStater implements HttpAsyncRequestHandler<String> {
    protected static final String TEXT = "text";

    protected final SpLogger spLogger;

    public SearchBackendProxyHandler(final ImmutableStaterConfig config, final SpLogger spLogger) {
        super(config);
        this.spLogger = spLogger;
    }

    public void stat(final int status, final long startTime) {
        accept(new RequestInfo(TimeSource.INSTANCE.currentTimeMillis(), status, startTime, startTime, 0L, 0L));
    }

    @Override
    public AsyncStringConsumer processRequest(final HttpRequest request, final HttpContext context)
        throws ServerException
    {
        if (RequestHandlerMapper.POST.equals(request.getRequestLine().getMethod())) {
            throw new ServerException(HttpStatus.SC_METHOD_NOT_ALLOWED, "Method not allowed");
        }
        return new AsyncStringConsumer();
    }

    @Override
    @SuppressWarnings("FutureReturnValueIgnored")
    public void handle(final String payload, final HttpAsyncExchange exchange, final HttpContext context)
        throws HttpException
    {
        long startTime = TimeSource.INSTANCE.currentTimeMillis();
        ProxySession session = new BasicProxySession(spLogger, exchange, context);
        String method = exchange.getRequest().getRequestLine().getMethod();
        String uri = exchange.getRequest().getRequestLine().getUri();
        session.logger().info("SearchBackendProxyHandler: method=" + method + ", uri=" + uri);
        if (RequestHandlerMapper.GET.equals(method)) {
            session.logger().info("Search query=" + exchange.getRequest().getRequestLine().getUri());
            CgiParams params = session.params();
            if (params.containsKey(LogContext.PREFIX) || params.containsKey(SearchParam.QUEUEID.paramName())) {
                long prefix;
                if (params.containsKey(LogContext.PREFIX)) {
                    prefix = params.getLong(LogContext.PREFIX);
                } else {
                    prefix = LogRecordContext.prefix(params.getLastOrNull(SearchParam.QUEUEID.paramName()), spLogger);
                }
                if (!params.containsKey(TEXT)) {
                    params.add(TEXT, "");
                }
                for (SearchParam param : SearchParam.params()) {
                    if (param.indexField() != null && params.containsKey(param.paramName())) {
                        StringBuilder sb = new StringBuilder(params.get(TEXT).get(0));
                        if (!sb.toString().isEmpty()) {
                            sb.append(" AND ");
                        }
                        sb.append(param.indexField().fieldName()).append(':');
                        sb.append(params.get(param.paramName()).get(0));
                        params.get(TEXT).set(0, sb.toString());
                    }
                }
                QueryConstructor query = new QueryConstructor(session.uri().rawPath());
                for (String key : params.keySet()) {
                    query.append(key, params.get(key).get(0));
                }
                User user = new User(spLogger.config().indexingQueueName(), new LongPrefix(prefix));
                session.logger().info("requestIndexData: query=" + uri + ", prefix=" + prefix + ", user=" + user);
                AsyncClient client = spLogger.searchClient().adjust(session.context());
                UniversalSearchProxyRequestContext requestContext =
                    new PlainUniversalSearchProxyRequestContext(
                        user,
                        null,
                        true,
                        client,
                        session.logger());
                spLogger.sequentialRequest(
                    session,
                    requestContext,
                    new BasicAsyncRequestProducerGenerator(query.toString()),
                    null,
                    true,
                    JsonAsyncTypesafeDomConsumerFactory.OK,
                    session.listener().createContextGeneratorFor(client),
                    new SearchBackendProxyCallback(session, startTime));
            } else {
                spLogger.unprefixedParallelRequest(session, uri, new SearchBackendProxyCallback(session, startTime));
            }
        } else {
            stat(YandexHttpStatus.SC_METHOD_NOT_ALLOWED, startTime);
            throw new ServerException(HttpStatus.SC_METHOD_NOT_ALLOWED, "Method Not Allowed");
        }
    }

    public class SearchBackendProxyCallback extends AbstractProxySessionCallback<JsonObject>
    {
        private final long startTime;

        public SearchBackendProxyCallback(final ProxySession session, final long startTime) {
            super(session);
            this.startTime = startTime;
        }

        @Override
        public void completed(final JsonObject json) {
            stat(HttpStatus.SC_OK, startTime);
            session.response(
                HttpStatus.SC_OK,
                new NStringEntity(
                    JsonType.NORMAL.toString(json),
                    ContentType.APPLICATION_JSON.withCharset(session.acceptedCharset())));
        }

        @Override
        public void cancelled() {
            stat(YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST, startTime);
            session.logger().warning(
                "SearchBackendProxyCallback cancelled: " + session.listener().details());
        }

        @Override
        public void failed(Exception e) {
            if (e instanceof ServerException) {
                stat(((ServerException) e).statusCode(), startTime);
            } else {
                stat(YandexHttpStatus.SC_REMOTE_CLOSED_REQUEST, startTime);
            }
            session.logger().log(
                Level.WARNING,
                "SearchBackendProxyCallback failed to find message's info: "
                    + session.listener().details() + " because of exception: ",
                e);
        }
    }
}
