package ru.yandex.mail.so.logger;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public enum SearchParam {
    // CGI-params for saving & searching of delivery-logs
    QUEUEID("queueid", "String", IndexField.QUEUEID),
    UID("uid", "Long", IndexField.UID),
    MSGID("msgid", "String", IndexField.MSGID),
    RCPT_UIDS("rcpts_uids", "Long", IndexField.RCPT_UID),
    //LOGIN("login", "String", IndexField.LOGIN),
    FROMADDR("fromaddr", "String", IndexField.FROMADDR),
    SOURCE_IP("source_ip", "String", IndexField.SOURCE_IP),
    MX("mx", "String", IndexField.MX),
    LOCL("locl", "String", IndexField.LOCL),
    CODE("code", "Long", IndexField.CODE),
    ROUTE("route", "String", IndexField.ROUTE),
    TS("ts", "Long", IndexField.TS),
    // for searching only
    RCPT_UID("rcpt_uid", "Long", IndexField.RCPT_UID),
    STID("stid", "String", IndexField.STID),
    EXPIRE_TIMESTAMP("expire_timestamp", "Long", IndexField.EXPIRE_TIMESTAMP),
    SERVICE("service", "String", null),
    LIMIT("limit", "Integer", null),
    SKIP("skip", "Integer", null),
    MINTIME("mintime", "Long", null),
    MAXTIME("maxtime", "Long", null),
    GETBYID("getbyid", "Boolean", null),
    UNIQ_MSG("uniq_msg", "Boolean", null);

    private static final List<SearchParam> params;

    private final String paramName;
    private final String itemType;
    private final IndexField indexField;

    static {
        TreeSet<SearchParam> list = new TreeSet<>(Comparator.comparingInt(Enum::ordinal));
        List<SearchParam> tail = new ArrayList<>();
        for (SearchParam param : values()) {
            if (param.indexField == null) {
                tail.add(param);
            } else {
                list.add(param);
            }
        }
        params = new ArrayList<>(list);
        params.addAll(tail);
    }

    SearchParam(final String paramName, final String itemType, final IndexField indexField) {
        this.paramName = paramName;
        this.itemType = itemType;
        this.indexField = indexField;
    }

    public String paramName() {
        return paramName;
    }

    public String itemType() {
        return itemType;
    }

    public IndexField indexField() {
        return indexField;
    }

    @Override
    public String toString() {
        return paramName;
    }

    public static List<SearchParam> params() {
        return params;
    }
}
