package ru.yandex.mail.so.logger;

import java.util.HashMap;
import java.util.Map;

public enum SoResolution {
    HAM(1),
    DLV(2),
    SPAM(4),
    PERS_HAM(8),
    PERS_SPAM(127),
    MALIC(256),
    SKIP(0);

    private final int code;
    private static final Map<Integer, SoResolution> codeToSoResolution = new HashMap<>();

    static {
        for (final SoResolution soResolution : SoResolution.values()) {
            codeToSoResolution.put(soResolution.code(), soResolution);
        }
    }

    SoResolution(final int code) {
        this.code = code;
    }

    public int code() {
        return code;
    }

    public static SoResolution fromCode(final int code) {
        return codeToSoResolution.get(code);
    }

    boolean isSpam() {
        return code == 4 || code == 127 || code == 256;
    }

    boolean isHam() {
        return code == 1 || code == 2 || code == 8;
    }
}
