package ru.yandex.mail.so.logger;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.EntityGenerator;
import ru.yandex.http.util.nio.NByteArrayEntityGeneratorAsyncConsumer;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonType;

public class UnprefixedParallelRequestHandler implements HttpAsyncRequestHandler<EntityGenerator> {
    private final SpLogger spLogger;

    public UnprefixedParallelRequestHandler(final SpLogger spLogger) {
        this.spLogger = spLogger;
    }

    @Override
    public NByteArrayEntityGeneratorAsyncConsumer processRequest(final HttpRequest request, final HttpContext context) {
        return new NByteArrayEntityGeneratorAsyncConsumer();
    }

    @Override
    public void handle(final EntityGenerator requestBody, final HttpAsyncExchange exchange, final HttpContext context)
        throws HttpException
    {
        ProxySession session = new BasicProxySession(spLogger, exchange, context);
        spLogger.unprefixedParallelRequest(
            session,
            session.request().getRequestLine().getUri(),
            new AbstractProxySessionCallback<>(session) {
                @Override
                public void completed(final JsonObject json) {
                    session.response(
                        HttpStatus.SC_OK,
                        new NStringEntity(
                            JsonType.NORMAL.toString(json),
                            ContentType.APPLICATION_JSON.withCharset(session.acceptedCharset())));
                }
            });
    }
}
