package ru.yandex.mail.so.logger.config;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.mail.so.logger.AuxiliaryStorageType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.IntegerParser;

public abstract class AbstractAuxiliaryStorageConfigBuilder<T extends AbstractAuxiliaryStorageConfigBuilder<T>>
    extends AbstractHttpHostConfigBuilder<T> implements AuxiliaryStorageConfig
{
    private AuxiliaryStorageType type;
    private String path;
    private String name;
    private String compression;
    private long batchMinSize;
    private long batchSavePeriod;
    private int batchSaveRetries;
    private long batchSaveRetryTimeout;
    private int workers;
    private long savingOperationTimeout;

    protected AbstractAuxiliaryStorageConfigBuilder(final AuxiliaryStorageConfig config) {
        super(config);
        type = config.type();
        path = config.path();
        name = config.name();
        compression = config.compression();
        batchMinSize = config.batchMinSize();
        batchSavePeriod = config.batchSavePeriod();
        batchSaveRetries = config.batchSaveRetries();
        batchSaveRetryTimeout = config.batchSaveRetryTimeout();
        workers = config.workers();
        savingOperationTimeout = config.savingOperationTimeout();
    }

    protected AbstractAuxiliaryStorageConfigBuilder(
        final IniConfig config,
        final String name,
        final AuxiliaryStorageConfig defaults)
        throws ConfigException
    {
        super(config, defaults == null ? HttpHostConfigDefaults.INSTANCE : defaults);
        this.name = name;
        if (config == null) {
            type = defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.type() : defaults.type();
            path = defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.path() : defaults.path();
            compression = defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.compression()
                : defaults.compression();
            batchMinSize = defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.batchMinSize()
                : defaults.batchMinSize();
            batchSavePeriod = defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.batchSavePeriod()
                : defaults.batchSavePeriod();
            batchSaveRetries = defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.batchSaveRetries()
                : defaults.batchSaveRetries();
            batchSaveRetryTimeout = defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.batchSaveRetryTimeout()
                : defaults.batchSaveRetryTimeout();
            workers = defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.workers() : defaults.workers();
            savingOperationTimeout = defaults == null
                ? AuxiliaryStorageConfigDefaults.INSTANCE.savingOperationTimeout() : defaults.savingOperationTimeout();
        } else {
            type = config.get(
                "type",
                defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.type() : defaults.type(),
                new EnumParser<>(AuxiliaryStorageType.class));
            path = config.getString(
                "path",
                defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.path() : defaults.path());
            compression = config.getString(
                "compression",
                defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.compression()  : defaults.compression());
            batchMinSize = config.get(
                "batch-min-size",
                defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.batchMinSize() : defaults.batchMinSize(),
                DurationParser.POSITIVE_LONG);
            batchSavePeriod = config.get(
                "batch-save-period",
                defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.batchSavePeriod()
                    : defaults.batchSavePeriod(),
                DurationParser.POSITIVE_LONG);
            batchSaveRetries = config.get(
                "batch-save-retries",
                defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.batchSaveRetries()
                    : defaults.batchSaveRetries(),
                IntegerParser.INSTANCE);
            batchSaveRetryTimeout = config.get(
                "batch-save-retry-timeout",
                defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.batchSaveRetryTimeout()
                    : defaults.batchSaveRetryTimeout(),
                DurationParser.POSITIVE_LONG);
            workers = config.get(
                "workers",
                defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.workers() : defaults.workers(),
                IntegerParser.INSTANCE);
            savingOperationTimeout = config.get(
                "saving-operation-timeout",
                defaults == null ? AuxiliaryStorageConfigDefaults.INSTANCE.savingOperationTimeout()
                    : defaults.savingOperationTimeout(),
                DurationParser.POSITIVE_LONG);
        }
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public AuxiliaryStorageType type() {
        return type;
    }

    public T type(final AuxiliaryStorageType type) {
        this.type = type;
        return self();
    }

    @Override
    public String path() {
        return path;
    }

    public T path(final String path) {
        this.path = path;
        return self();
    }

    @Override
    public String compression() {
        return compression;
    }

    public T compression(final String compression) {
        this.compression = compression;
        return self();
    }

    @Override
    public long batchMinSize() {
        return batchMinSize;
    }

    public T batchMinSize(final long batchSize) {
        this.batchMinSize = batchSize;
        return self();
    }

    @Override
    public long batchSavePeriod() {
        return batchSavePeriod;
    }

    public T batchSaveTimeout(final long batchSaveTimeout) {
        this.batchSavePeriod = batchSaveTimeout;
        return self();
    }

    @Override
    public int batchSaveRetries() {
        return batchSaveRetries;
    }

    public T batchSaveRetries(final int batchSaveRetries) {
        this.batchSaveRetries = batchSaveRetries;
        return self();
    }

    @Override
    public long batchSaveRetryTimeout() {
        return batchSaveRetryTimeout;
    }

    public T batchSaveRetryTimeout(final long batchSaveRetryTimeout) {
        this.batchSaveRetryTimeout = batchSaveRetryTimeout;
        return self();
    }

    @Override
    public int workers() {
        return workers;
    }

    public T workers(final int workers) {
        this.workers = workers;
        return self();
    }

    @Override
    public long savingOperationTimeout() {
        return savingOperationTimeout;
    }

    public T savingOperationTimeout(final long savingOperationTimeout) {
        this.savingOperationTimeout = savingOperationTimeout;
        return self();
    }
}
