package ru.yandex.mail.so.logger.config;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractAuxiliaryStoragesConfigBuilder<T extends AbstractAuxiliaryStoragesConfigBuilder<T>>
    implements ConfigBuilder<T>, AuxiliaryStoragesConfig
{
    public static final String SECTION = "auxiliary-storage";

    private Map<String, AuxiliaryStorageConfig> storageConfigs;

    protected AbstractAuxiliaryStoragesConfigBuilder() {
        this(AuxiliaryStoragesConfigDefaults.INSTANCE);
    }

    protected AbstractAuxiliaryStoragesConfigBuilder(final AuxiliaryStoragesConfig config)
    {
        storageConfigs = new HashMap<>(config.storageConfigs());
    }

    protected AbstractAuxiliaryStoragesConfigBuilder(final IniConfig config) throws ConfigException
    {
        this(config, AuxiliaryStoragesConfigDefaults.INSTANCE);
    }

    protected AbstractAuxiliaryStoragesConfigBuilder(final IniConfig config, final AuxiliaryStoragesConfig defaults)
        throws ConfigException
    {
        storageConfigs = loadAuxiliaryStorages(config, defaults);
    }

    public static Map<String, AuxiliaryStorageConfig> loadAuxiliaryStorages(
        final IniConfig section,
        final AuxiliaryStoragesConfig defaults)
        throws ConfigException
    {
        Map<String, AuxiliaryStorageConfig> storageConfigs = new HashMap<>();
        for (Map.Entry<String, IniConfig> entry : section.sections().entrySet()) {
            String subsection = entry.getKey();
            AuxiliaryStorageConfig subsectionDefaults =
                defaults == null ? null : defaults.storageConfigs().get(subsection);
            storageConfigs.put(
                subsection,
                new AuxiliaryStorageConfigBuilder(entry.getValue(), subsection, subsectionDefaults));
        }
        return storageConfigs;
    }

    @Override
    public Map<String, AuxiliaryStorageConfig> storageConfigs() {
        return storageConfigs;
    }

    public T storageConfigs(final Map<String, ? extends AuxiliaryStorageConfig> storageConfigs) {
        this.storageConfigs = new HashMap<>(storageConfigs);
        return self();
    }

    public T logStorage(final String name, final AuxiliaryStorageConfig storageConfig) {
        storageConfigs.put(name, storageConfig);
        return self();
    }

    public ImmutableAuxiliaryStoragesConfig build() throws ConfigException {
        return new ImmutableAuxiliaryStoragesConfig(this);
    }
}
