package ru.yandex.mail.so.logger.config;

import java.util.Map;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.request.RequestPatternParser;
import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractLogRecordsHandlersConfigBuilder<T extends AbstractLogRecordsHandlersConfigBuilder<T>>
    implements ConfigBuilder<T>, LogRecordsHandlersConfig
{
    public static final String SECTION = "log-handler";

    private static final GenericFunction<LogRecordsHandlerConfig, LogRecordsHandlerConfigBuilder, RuntimeException>
        TRANSFORMER = config -> {
            if (config == null) {
                return null;
            } else {
                return new LogRecordsHandlerConfigBuilder(config);
            }
        };

    private PatternMap<RequestInfo, LogRecordsHandlerConfigBuilder> logRecordsHandlers;

    protected AbstractLogRecordsHandlersConfigBuilder() {
        this(LogRecordsHandlersConfigDefaults.INSTANCE);
    }

    protected AbstractLogRecordsHandlersConfigBuilder(final LogRecordsHandlersConfig config)
    {
        logRecordsHandlers = config.logRecordsHandlers().transform(TRANSFORMER);
    }

    protected AbstractLogRecordsHandlersConfigBuilder(final IniConfig config) throws ConfigException
    {
        this(config, LogRecordsHandlersConfigDefaults.INSTANCE);
    }

    protected AbstractLogRecordsHandlersConfigBuilder(final IniConfig config, final LogRecordsHandlersConfig defaults)
        throws ConfigException
    {
        logRecordsHandlers = loadLogRecordsHandlers(config, defaults);
        asterisk(new LogRecordsHandlerConfigBuilder());
    }

    public static PatternMap<RequestInfo, LogRecordsHandlerConfigBuilder> loadLogRecordsHandlers(
        final IniConfig section,
        final LogRecordsHandlersConfig defaults)
        throws ConfigException
    {
        PatternMap<RequestInfo, LogRecordsHandlerConfigBuilder> logRecordsHandlers = new PatternMap<>(
            new LogRecordsHandlerConfigBuilder(section, defaults.logRecordsHandlers().asterisk()));
        for (Map.Entry<String, IniConfig> entry : section.sections().entrySet()) {
            String subsection = entry.getKey();
            if (subsection.indexOf('/') != -1 || subsection.indexOf(':') != -1 || subsection.indexOf('*') != -1) {
                Pattern<RequestInfo> pattern = RequestPatternParser.INSTANCE.apply(subsection);
                logRecordsHandlers.put(
                    pattern,
                    new LogRecordsHandlerConfigBuilder(entry.getValue(), defaults.logRecordsHandlers().get(pattern)));
            }
        }
        return logRecordsHandlers;
    }

    @Override
    public PatternMap<RequestInfo, LogRecordsHandlerConfigBuilder> logRecordsHandlers() {
        return logRecordsHandlers;
    }

    public T logRecordsHandlers(final PatternMap<RequestInfo, ? extends LogRecordsHandlerConfig> logRecordsHandlers) {
        this.logRecordsHandlers = logRecordsHandlers.transform(TRANSFORMER);
        return self();
    }

    public T logRecordsHandler(
        final Pattern<RequestInfo> pattern,
        final LogRecordsHandlerConfigBuilder logRecordsHandler)
    {
        logRecordsHandlers.put(pattern, logRecordsHandler);
        return self();
    }

    public T asterisk(final LogRecordsHandlerConfigBuilder logRecordsHandler) {
        logRecordsHandlers.put(new Pattern<>("", true), logRecordsHandler);
        return self();
    }

    public ImmutableLogRecordsHandlersConfig build() throws ConfigException {
        return new ImmutableLogRecordsHandlersConfig(this);
    }
}
