package ru.yandex.mail.so.logger.config;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.mail.so.logger.LogStorageType;
import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.EnumParser;

public abstract class AbstractLogStoragesConfigBuilder<T extends AbstractLogStoragesConfigBuilder<T>>
    implements ConfigBuilder<T>, LogStoragesConfig
{
    public static final String SECTION = "log-storage";

    private Map<String, LogStorageConfig> logStorages;

    protected AbstractLogStoragesConfigBuilder() {
        this(LogStoragesConfigDefaults.INSTANCE);
    }

    protected AbstractLogStoragesConfigBuilder(final LogStoragesConfig config)
    {
        logStorages = new HashMap<>(config.storageConfigs());
    }

    protected AbstractLogStoragesConfigBuilder(final IniConfig config) throws ConfigException
    {
        this(config, LogStoragesConfigDefaults.INSTANCE);
    }

    protected AbstractLogStoragesConfigBuilder(final IniConfig config, final LogStoragesConfig defaults)
        throws ConfigException
    {
        logStorages = loadLogStorages(config, defaults);
    }

    public static Map<String, LogStorageConfig> loadLogStorages(
        final IniConfig section,
        final LogStoragesConfig defaults)
        throws ConfigException
    {
        Map<String, LogStorageConfig> logStorages = new HashMap<>();
        EnumParser<LogStorageType> parser = new EnumParser<>(LogStorageType.class);
        for (Map.Entry<String, IniConfig> entry : section.sections().entrySet()) {
            String subsection = entry.getKey();
            LogStorageConfig subsectionDefaults = defaults.storageConfigs().get(subsection);
            if (subsectionDefaults != null && subsectionDefaults.type() == LogStorageType.NULL) {
                subsectionDefaults = null;
            }
            IniConfig subsectionConfig = entry.getValue();
            LogStorageType subsectionType = subsectionConfig.get("type", LogStorageType.NULL, parser);
            if (subsectionDefaults != null && subsectionDefaults.type() != subsectionType) {
                throw new ConfigException("subsection storage type mismatch: "
                    + "subsection type is " + subsectionType + ", while parent is " + subsectionDefaults.type());
            }
            logStorages.put(subsection, subsectionType.createConfig(subsectionConfig, subsection, subsectionDefaults));
        }
        return logStorages;
    }

    @Override
    public Map<String, LogStorageConfig> storageConfigs() {
        return logStorages;
    }

    public T logStorages(final Map<String, ? extends LogStorageConfig> logStorages) {
        this.logStorages = new HashMap<>(logStorages);
        return self();
    }

    public T logStorage(final String name, final LogStorageConfig logStorage) {
        logStorages.put(name, logStorage);
        return self();
    }

    public ImmutableLogStoragesConfig build() throws ConfigException {
        return new ImmutableLogStoragesConfig(this);
    }
}
