package ru.yandex.mail.so.logger.config;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.mail.so.logger.BasicRoutedLogRecordProducer;
import ru.yandex.mail.so.logger.MongoResultType;
import ru.yandex.mail.so.logger.NullRulesStatDatabase;
import ru.yandex.mail.so.logger.RulesStatDatabaseType;
import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.EnumParser;

public abstract class AbstractRulesStatDatabasesConfigBuilder<T extends AbstractRulesStatDatabasesConfigBuilder<T>>
    implements ConfigBuilder<T>, RulesStatDatabasesConfig<BasicRoutedLogRecordProducer>
{
    public static final String SECTION = "rules-stat";

    private Map<String, RulesStatDatabaseConfig<BasicRoutedLogRecordProducer>> rulesStatDatabases;
    private Map<String, Map<MongoResultType, TimeFrameQueue<Long>>> specStaters;

    protected AbstractRulesStatDatabasesConfigBuilder() {
        this(RulesStatDatabasesConfigDefaults.INSTANCE);
    }

    protected AbstractRulesStatDatabasesConfigBuilder(
        final RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> config)
    {
        rulesStatDatabases = new HashMap<>(config.rulesStatDatabases());
        specStaters = new HashMap<>(config.specStaters());
    }

    protected AbstractRulesStatDatabasesConfigBuilder(final IniConfig config) throws ConfigException {
        this(config, RulesStatDatabasesConfigDefaults.INSTANCE);
    }

    protected AbstractRulesStatDatabasesConfigBuilder(
        final IniConfig config,
        final RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> defaults)
        throws ConfigException
    {
        rulesStatDatabases = loadRulesStatDatabaseConfigs(config, defaults);
        specStaters = new HashMap<>();
    }

    public static Map<String, RulesStatDatabaseConfig<BasicRoutedLogRecordProducer>> loadRulesStatDatabaseConfigs(
        final IniConfig section,
        final RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> defaults)
        throws ConfigException
    {
        Map<String, RulesStatDatabaseConfig<BasicRoutedLogRecordProducer>> rulesStatDatabases = new HashMap<>();
        if (section == null) {
            rulesStatDatabases.put(NullRulesStatDatabase.NULL, NullRulesStatDatabaseConfig.INSTANCE);
        } else {
            EnumParser<RulesStatDatabaseType> parser = new EnumParser<>(RulesStatDatabaseType.class);
            for (Map.Entry<String, IniConfig> entry : section.sections().entrySet()) {
                String subsection = entry.getKey();
                //System.err.println("Loading of config for rules Stats DB: " + subsection);
                RulesStatDatabaseConfig<BasicRoutedLogRecordProducer> subsectionDefaults =
                    defaults.rulesStatDatabases().get(subsection);
                if (subsectionDefaults != null && subsectionDefaults.type() == RulesStatDatabaseType.NULL) {
                    subsectionDefaults = null;
                }
                IniConfig subsectionConfig = entry.getValue();
                if (subsectionConfig == null) {
                    rulesStatDatabases.put(subsection, NullRulesStatDatabaseConfig.INSTANCE);
                    //System.err.println("Loading of config for rules Stats DB: " + subsection + ", type=null");
                } else {
                    RulesStatDatabaseType subsectionType =
                        subsectionConfig.get("type", RulesStatDatabaseType.NULL, parser);
                    if (subsectionDefaults != null && subsectionDefaults.type() != subsectionType) {
                        throw new ConfigException("subsection storage type mismatch: subsection type is "
                            + subsectionType + ", while parent is " + subsectionDefaults.type());
                    }
                    //System.err.println("Loading of config for rules Stats DB: " + subsection + ", type="
                    //    + subsectionType);
                    rulesStatDatabases.put(
                        subsection,
                        subsectionType.createConfig(subsectionConfig, subsection, subsectionDefaults));
                }
            }
        }
        return rulesStatDatabases;
    }

    @Override
    public Map<String, RulesStatDatabaseConfig<BasicRoutedLogRecordProducer>> rulesStatDatabases() {
        return rulesStatDatabases;
    }

    public T rulesStatDatabases(
        final Map<String, ? extends RulesStatDatabaseConfig<BasicRoutedLogRecordProducer>> rulesStatDatabases)
    {
        this.rulesStatDatabases = new HashMap<>(rulesStatDatabases);
        return self();
    }

    public T rulesStatDatabases(
        final String name,
        final RulesStatDatabaseConfig<BasicRoutedLogRecordProducer> rulesStatDatabaseConfig)
    {
        rulesStatDatabases.put(name, rulesStatDatabaseConfig);
        return self();
    }

    @Override
    public Map<String, Map<MongoResultType, TimeFrameQueue<Long>>> specStaters() {
        return specStaters;
    }

    public T specStaters(final Map<String, Map<MongoResultType, TimeFrameQueue<Long>>> specStaters) {
        this.specStaters = specStaters;
        return self();
    }

    public ImmutableRulesStatDatabasesConfig build() throws ConfigException {
        return new ImmutableRulesStatDatabasesConfig(this);
    }
}
