package ru.yandex.mail.so.logger.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.logger.MinimalLoggerConfigDefaults;
import ru.yandex.mail.so.logger.BasicRoutedLogRecordProducer;
import ru.yandex.mail.so.logger.Route;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveIntegerValidator;
import ru.yandex.parser.string.PositiveLongValidator;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;
import ru.yandex.stater.StaterConfig;
import ru.yandex.stater.StaterConfigBuilder;

public abstract class AbstractSpLoggerConfigBuilder<T extends AbstractSpLoggerConfigBuilder<T>>
    extends AbstractUniversalSearchProxyConfigBuilder<T> implements SpLoggerConfig
{
    private HttpHostConfigBuilder producerAsyncClientConfig;
    private String deliveryLogPath;
    private LoggerConfig spareDeliveryLog;
    private LogStoragesConfigBuilder logStoragesConfig;
    private AuxiliaryStoragesConfig auxiliaryStoragesConfig;
    private LogRecordsHandlersConfigBuilder logRecordsHandlersConfig;
    private RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> rulesStatDatabasesConfig;
    private String indexingQueueName;
    private StaterConfigBuilder indexSearchStaterConfig;
    private long searchTimeout;
    private int searchBackendShardsNumber;
    private Route route;
    private EnvironmentType envType;

    protected AbstractSpLoggerConfigBuilder(final SpLoggerConfig config) {
        super(config);
        if (config.producerAsyncClientConfig() != null) {
            producerAsyncClientConfig(config.producerAsyncClientConfig());
        } else {
            producerAsyncClientConfig(config.producerClientConfig());
        }
        deliveryLogPath(config.deliveryLogPath());
        spareDeliveryLog(config.spareDeliveryLog());
        logStoragesConfig(config.logStoragesConfig());
        logRecordsHandlersConfig(config.logRecordsHandlersConfig());
        rulesStatDatabasesConfig(config.rulesStatDatabasesConfig());
        indexingQueueName(config.indexingQueueName());
        indexSearchStaterConfig(config.indexSearchStaterConfig());
        searchTimeout(config.searchTimeout());
        searchBackendShardsNumber(config.searchBackendShardsNumber());
        route(config.route());
        envType(config.envType());
    }

    protected AbstractSpLoggerConfigBuilder(final IniConfig config, final SpLoggerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        deliveryLogPath = config.getOrNull("delivery-log.file");
        spareDeliveryLog =
            new LoggerConfigBuilder(config.section("spare-delivery-log"), MinimalLoggerConfigDefaults.INSTANCE);
        logStoragesConfig =
            new LogStoragesConfigBuilder(
                config.section(LogStoragesConfigBuilder.SECTION),
                defaults.logStoragesConfig());
        auxiliaryStoragesConfig =
            new AuxiliaryStoragesConfigBuilder(
                config.section(AuxiliaryStoragesConfigBuilder.SECTION),
                defaults.auxiliaryStoragesConfig());
        rulesStatDatabasesConfig =
            new RulesStatDatabasesConfigBuilder(
                config.section(RulesStatDatabasesConfigBuilder.SECTION),
                defaults.rulesStatDatabasesConfig());
        logRecordsHandlersConfig =
            new LogRecordsHandlersConfigBuilder(
                config.section(LogRecordsHandlersConfigBuilder.SECTION),
                defaults.logRecordsHandlersConfig());
        IniConfig spLoggerConfig = config.section("sp-logger");
        indexingQueueName = spLoggerConfig.get(
            "indexing-queue-name",
            defaults.indexingQueueName(),
            NonEmptyValidator.INSTANCE);
        if (indexingQueueName != null) {
            producerAsyncClientConfig =
                new HttpHostConfigBuilder(
                    config.section("producer-async-client"),
                    defaults.producerAsyncClientConfig());
        }
        indexSearchStaterConfig =
            new StaterConfigBuilder(config.section("index-search-stat"), defaults.indexSearchStaterConfig());
        searchTimeout = spLoggerConfig.get("search-timeout", defaults.searchTimeout(), PositiveLongValidator.INSTANCE);
        searchBackendShardsNumber = spLoggerConfig.get(
            "search-backend-shards-number",
            defaults.searchBackendShardsNumber(),
            PositiveIntegerValidator.INSTANCE);
        route = spLoggerConfig.get("route", defaults.route(), new EnumParser<>(Route.class));
        envType = spLoggerConfig.get("env-type", defaults.envType(), new EnvironmentType.Parser());

    }

    @Override
    public HttpHostConfigBuilder producerAsyncClientConfig() {
        return this.producerAsyncClientConfig;
    }

    public T producerAsyncClientConfig(final HttpHostConfig producerAsyncClientConfig) {
        this.producerAsyncClientConfig = new HttpHostConfigBuilder(producerAsyncClientConfig);
        return this.self();
    }

    @Override
    public String deliveryLogPath() {
        return deliveryLogPath;
    }

    public T deliveryLogPath(final String deliveryLogPath) {
        this.deliveryLogPath = deliveryLogPath;
        return self();
    }

    @Override
    public LoggerConfig spareDeliveryLog() {
        return spareDeliveryLog;
    }

    public T spareDeliveryLog(final LoggerConfig spareDeliveryLog) {
        this.spareDeliveryLog = new LoggerConfigBuilder(spareDeliveryLog);
        return self();
    }

    @Override
    public LogStoragesConfigBuilder logStoragesConfig() {
        return logStoragesConfig;
    }

    public T logStoragesConfig(final LogStoragesConfig logStoragesConfig) {
        this.logStoragesConfig = new LogStoragesConfigBuilder(logStoragesConfig);
        return self();
    }

    @Override
    public AuxiliaryStoragesConfig auxiliaryStoragesConfig() {
        return auxiliaryStoragesConfig;
    }

    public T auxiliaryStoragesConfig(final AuxiliaryStoragesConfig auxiliaryStoragesConfig) {
        this.auxiliaryStoragesConfig = auxiliaryStoragesConfig;
        return self();
    }

    @Override
    public LogRecordsHandlersConfigBuilder logRecordsHandlersConfig() {
        return logRecordsHandlersConfig;
    }

    public T logRecordsHandlersConfig(final LogRecordsHandlersConfig logRecordsHandlersConfig) {
        this.logRecordsHandlersConfig = new LogRecordsHandlersConfigBuilder(logRecordsHandlersConfig);
        return self();
    }

    @Override
    public RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> rulesStatDatabasesConfig() {
        return rulesStatDatabasesConfig;
    }

    public T rulesStatDatabasesConfig(
            final RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> rulesStatDatabasesConfig)
    {
        this.rulesStatDatabasesConfig = new RulesStatDatabasesConfigBuilder(rulesStatDatabasesConfig);
        return self();
    }

    @Override
    public String indexingQueueName() {
        return indexingQueueName;
    }

    public T indexingQueueName(final String indexingQueueName) {
        this.indexingQueueName = indexingQueueName;
        return self();
    }

    @Override
    public StaterConfig indexSearchStaterConfig() {
        return indexSearchStaterConfig;
    }

    public T indexSearchStaterConfig(final StaterConfig indexSearchStaterConfig) {
        this.indexSearchStaterConfig = new StaterConfigBuilder(indexSearchStaterConfig);
        return self();
    }

    @Override
    public long searchTimeout() {
        return searchTimeout;
    }

    public T searchTimeout(final long searchTimeout) {
        this.searchTimeout = searchTimeout;
        return self();
    }

    @Override
    public int searchBackendShardsNumber() {
        return searchBackendShardsNumber;
    }

    public T searchBackendShardsNumber(final int searchBackendShardsNumber) {
        this.searchBackendShardsNumber = searchBackendShardsNumber;
        return self();
    }

    @Override
    public Route route() {
        return route;
    }

    public T route(final Route route) {
        this.route = route;
        return self();
    }

    @Override
    public EnvironmentType envType() {
        return envType;
    }

    public T envType(final EnvironmentType envType) {
        this.envType = envType;
        return self();
    }
}
