package ru.yandex.mail.so.logger.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.mail.so.logger.AuxiliaryStorageType;

public interface AuxiliaryStorageConfig extends HttpHostConfig, BatchSaverConfig {
    /**
     * Get type of the auxiliary log storage
     *
     * @return type of the auxiliary log storage
     */
    @Override
    AuxiliaryStorageType type();

    /**
     * Get basic URI path used for building requests to the storage
     *
     * @return basic URI path used for building requests to the storage
     */
    String path();

    /**
     * Get compression method for all logs to be sent into this auxiliary storage
     *
     * @return compression method for all logs to be sent into this auxiliary storage
     */
    String compression();
}
