package ru.yandex.mail.so.logger.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AuxiliaryStorageConfigBuilder extends AbstractAuxiliaryStorageConfigBuilder<AuxiliaryStorageConfigBuilder>
{
    public AuxiliaryStorageConfigBuilder() {
        super(AuxiliaryStorageConfigDefaults.INSTANCE);
    }

    public AuxiliaryStorageConfigBuilder(final AuxiliaryStorageConfig config) {
        super(config);
    }

    public AuxiliaryStorageConfigBuilder(final IniConfig config, final String name)
        throws ConfigException
    {
        super(config, name, AuxiliaryStorageConfigDefaults.INSTANCE);
    }

    public AuxiliaryStorageConfigBuilder(
        final IniConfig config,
        final String name,
        final AuxiliaryStorageConfig defaults)
        throws ConfigException
    {
        super(config, name, defaults);
    }

    @Override
    public AuxiliaryStorageConfigBuilder self() {
        return this;
    }

    public ImmutableAuxiliaryStorageConfig build() throws ConfigException {
        return new ImmutableAuxiliaryStorageConfig(this);
    }
}
