package ru.yandex.mail.so.logger.config;

public interface BatchSaverConfig {
    /**
     * Get symbolic name of this config.
     *
     * @return name of the config
     */
    String name();

    /**
     * Get type of the batch saver
     *
     * @return type of the batch saver
     */
    ConfigFactory<? extends BatchSaverConfig> type();

    /**
     * Get timeout (in milliseconds) between two different batches' operations that store data to DB.
     * (For timeout of single saving operation see {@link BatchSaverConfig#savingOperationTimeout()})
     *
     * @return timeout between two different batches' operations that store data to DB
     */
    long batchSavePeriod();

    /**
     * Get timeout between two attempts to save given batch
     *
     * @return timeout between two attempts to save given batch
     */
    long batchSaveRetryTimeout();

    /**
     * Get number of attempts to save given batch
     *
     * @return number of attempts to save given batch
     */
    int batchSaveRetries();

    /**
     * Get min size of the batch (number of log records)
     *
     * @return min size of the batch (number of log records)
     */
    long batchMinSize();

    /**
     * Get number of threads that perform saving data
     *
     * @return number of threads that perform saving data
     */
    int workers();

    /**
     * Get timeout (in milliseconds) for one saving operation that store data to DB.
     * In 'transactions' and 'bulk-requests' modes it's a timeout for the whole batch's saving operation.
     *
     * @return timeout (in milliseconds) for one saving operation that store data to DB
     */
    long savingOperationTimeout();
}
