package ru.yandex.mail.so.logger.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public interface ConfigFactory<C extends BatchSaverConfig> {
    /**
     * Creates config object from input data
     *
     * @param config input "raw" config
     * @param name symbolic config name
     * @param defaults config with default values
     * @return created config object
     */
    C createConfig(final IniConfig config, final String name, final C defaults) throws ConfigException;
}
