package ru.yandex.mail.so.logger.config;

import java.util.Locale;

import ru.yandex.parser.string.EnumParser;

public enum EnvironmentType {
    PRODUCTION("prod"),
    TESTING("test");

    private final String briefName;

    EnvironmentType(final String briefName) {
        this.briefName = briefName.toLowerCase(Locale.ROOT);
    }

    public String briefName() {
        return briefName;
    }

    public static class Parser extends EnumParser<EnvironmentType> {
        Parser() {
            super(EnvironmentType.class);
        }

        @Override
        public EnvironmentType apply(final String value) throws RuntimeException {
            if (value == null) {
                throw new NullPointerException("Name of environment type is null");
            }
            String inputStr = value.toLowerCase(Locale.ROOT);
            for (EnvironmentType envType : values()) {
                if (inputStr.contains(envType.briefName())) {
                    return envType;
                }
            }
            throw new IllegalArgumentException(
                "No enum constant " + EnvironmentType.class.getCanonicalName() + "." + value.toUpperCase(Locale.ROOT));
        }
    }
}
