package ru.yandex.mail.so.logger.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.mail.so.logger.AuxiliaryStorageType;
import ru.yandex.parser.config.ConfigException;

public class ImmutableAuxiliaryStorageConfig extends ImmutableHttpHostConfig implements AuxiliaryStorageConfig {
    private final AuxiliaryStorageType type;
    private final String path;
    private final String name;
    private final String compression;
    private final long batchMinSize;
    private final long batchSavePeriod;
    private final int batchSaveRetries;
    private final long batchSaveRetryTimeout;
    private final int workers;
    private final long savingOperationTimeout;

    public ImmutableAuxiliaryStorageConfig(final AuxiliaryStorageConfig config) throws ConfigException {
        super(config);
        type = config.type();
        path = config.path();
        name = config.name();
        compression = config.compression();
        batchMinSize = config.batchMinSize();
        batchSavePeriod = config.batchSavePeriod();
        batchSaveRetries = config.batchSaveRetries();
        batchSaveRetryTimeout = config.batchSaveRetryTimeout();
        workers = config.workers();
        savingOperationTimeout = config.savingOperationTimeout();
    }

    @Override
    public AuxiliaryStorageType type() {
        return type;
    }

    @Override
    public String path() {
        return path;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public String compression() {
        return compression;
    }

    @Override
    public long batchMinSize() {
        return batchMinSize;
    }

    @Override
    public long batchSavePeriod() {
        return batchSavePeriod;
    }

    @Override
    public int batchSaveRetries() {
        return batchSaveRetries;
    }

    @Override
    public long batchSaveRetryTimeout() {
        return batchSaveRetryTimeout;
    }

    @Override
    public int workers() {
        return workers;
    }

    @Override
    public long savingOperationTimeout() {
        return savingOperationTimeout;
    }
}
