package ru.yandex.mail.so.logger.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.mail.so.logger.AuxiliaryStorage;
import ru.yandex.mail.so.logger.LogStorageException;
import ru.yandex.mail.so.logger.SpLogger;
import ru.yandex.parser.config.ConfigException;

public class ImmutableAuxiliaryStoragesConfig implements AuxiliaryStoragesConfig {
    private final Map<String, ImmutableAuxiliaryStorageConfig> storageConfigs;

    public ImmutableAuxiliaryStoragesConfig(final AuxiliaryStoragesConfig config) throws ConfigException
    {
        if (config == null || config.storageConfigs().isEmpty()) {
            storageConfigs = Collections.emptyMap();
        } else {
            storageConfigs = new HashMap<>();
            for (Map.Entry<String, ? extends AuxiliaryStorageConfig> entry : config.storageConfigs().entrySet()) {
                storageConfigs.put(entry.getKey(), new ImmutableAuxiliaryStorageConfig(entry.getValue()));
            }
        }
    }

    @Override
    public Map<String, ImmutableAuxiliaryStorageConfig> storageConfigs() {
        return storageConfigs;
    }

    public Map<String, AuxiliaryStorage> prepareStorages(final SpLogger spLogger) throws LogStorageException {
        Map<String, AuxiliaryStorage> storages = new HashMap<>();
        for (Map.Entry<String, ImmutableAuxiliaryStorageConfig> entry : storageConfigs.entrySet()) {
            String name = entry.getKey();
            spLogger.logger().info("Configuring auxiliary storage <" + name + ">");
            ImmutableAuxiliaryStorageConfig config = entry.getValue();
            storages.put(name, config.type().createStorage(spLogger, config, name));
        }
        return storages;
    }
}
