package ru.yandex.mail.so.logger.config;

import java.util.Collections;
import java.util.List;

import ru.yandex.mail.so.logger.LogRecordsHandlerType;
import ru.yandex.mail.so.logger.Route;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.stater.ImmutableStaterConfig;

public class ImmutableLogRecordsHandlerConfig extends ImmutableStaterConfig implements LogRecordsHandlerConfig {
    private final LogRecordsHandlerType logRecordsHandlerType;
    private final String logStorage;
    private final long storeTTL;
    private final String rulesStatDatabase;
    private final String decompression;
    private final Route route;
    private final List<String> auxiliaryStorages;

    public ImmutableLogRecordsHandlerConfig(final LogRecordsHandlerConfig config) throws ConfigException {
        super(config);
        logRecordsHandlerType = config.type();
        logStorage = config.logStorage();
        storeTTL = config.storeTTL();
        rulesStatDatabase = config.rulesStatDatabase();
        decompression = config.decompression();
        route = config.route();
        auxiliaryStorages = Collections.unmodifiableList(config.auxiliaryStorages());
    }

    @Override
    public LogRecordsHandlerType type() {
        return logRecordsHandlerType;
    }

    @Override
    public String logStorage() {
        return logStorage;
    }

    @Override
    public long storeTTL() {
        return storeTTL;
    }

    @Override
    public String rulesStatDatabase() {
        return rulesStatDatabase;
    }

    @Override
    public String decompression() {
        return decompression;
    }

    @Override
    public Route route() {
        return route;
    }

    @Override
    public List<String> auxiliaryStorages() {
        return auxiliaryStorages;
    }
}
