package ru.yandex.mail.so.logger.config;

import ru.yandex.collection.PatternMap;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.parser.config.ConfigException;

public class ImmutableLogRecordsHandlersConfig implements LogRecordsHandlersConfig {
    private static final GenericFunction<LogRecordsHandlerConfig, ImmutableLogRecordsHandlerConfig, ConfigException>
        TRANSFORMER = config -> {
            if (config == null) {
                return null;
            } else {
                return new ImmutableLogRecordsHandlerConfig(config);
            }
        };

    private final PatternMap<RequestInfo, ImmutableLogRecordsHandlerConfig> logRecordsHandlerConfigs;

    public ImmutableLogRecordsHandlersConfig(final LogRecordsHandlersConfig config) throws ConfigException {
        logRecordsHandlerConfigs = config.logRecordsHandlers().transform(TRANSFORMER);
    }

    @Override
    public PatternMap<RequestInfo, ImmutableLogRecordsHandlerConfig> logRecordsHandlers() {
        return logRecordsHandlerConfigs;
    }
}
