package ru.yandex.mail.so.logger.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.mail.so.logger.LogRecordContext;
import ru.yandex.mail.so.logger.LogStorage;
import ru.yandex.mail.so.logger.LogStorageException;
import ru.yandex.mail.so.logger.NullLogStorage;
import ru.yandex.mail.so.logger.SpLogger;
import ru.yandex.parser.config.ConfigException;

public class ImmutableLogStoragesConfig implements LogStoragesConfig {
    private final Map<String, ? extends LogStorageConfig> logStorageConfigs;

    public ImmutableLogStoragesConfig(final LogStoragesConfig config) throws ConfigException
    {
        if (config == null || config.storageConfigs().isEmpty()) {
            logStorageConfigs = Collections.emptyMap();
        } else {
            logStorageConfigs = config.storageConfigs();
        }
    }

    @Override
    public Map<String, ? extends LogStorageConfig> storageConfigs() {
        return logStorageConfigs;
    }

    public Map<String, LogStorage<LogRecordContext>> prepareStorages(final SpLogger spLogger)
        throws LogStorageException
    {
        Map<String, LogStorage<LogRecordContext>> logStorages = new HashMap<>();
        logStorages.put(NullLogStorage.NULL, NullLogStorage.instance(spLogger));
        for (Map.Entry<String, ? extends LogStorageConfig> entry : logStorageConfigs.entrySet()) {
            String name = entry.getKey();
            spLogger.logger().info("Configuring storage <" + name + ">");
            LogStorageConfig config = entry.getValue();
            logStorages.put(name, config.createStorage(spLogger, name));
        }
        return logStorages;
    }
}
