package ru.yandex.mail.so.logger.config;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.mail.so.logger.BasicRoutedLogRecordProducer;
import ru.yandex.mail.so.logger.MongoResultType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.stater.CountAggregatorFactory;
import ru.yandex.stater.DuplexStaterFactory;
import ru.yandex.stater.IntegralSumAggregatorFactory;
import ru.yandex.stater.NamedStatsAggregatorFactory;
import ru.yandex.stater.PassiveStaterAdapter;

public class ImmutableRulesStatDatabasesConfig implements RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> {
    private final Map<String, ? extends RulesStatDatabaseConfig<BasicRoutedLogRecordProducer>>
        rulesStatDatabasesConfigs;
    private final Map<String, Map<MongoResultType, TimeFrameQueue<Long>>> specStaters;

    public ImmutableRulesStatDatabasesConfig(final RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> config)
        throws ConfigException
    {
        rulesStatDatabasesConfigs = config.rulesStatDatabases();
        specStaters = new HashMap<>();
    }

    @Override
    public Map<String, ? extends RulesStatDatabaseConfig<BasicRoutedLogRecordProducer>> rulesStatDatabases() {
        return rulesStatDatabasesConfigs;
    }

    @Override
    public Map<String, Map<MongoResultType, TimeFrameQueue<Long>>> specStaters() {
        return specStaters;
    }

    public void registerComponents(final HttpProxy<?> httpProxyServer) {
        TimeFrameQueue<Long> stater;
        for (String rulesStatDatabaseConfigName : rulesStatDatabasesConfigs.keySet()) {
            Map<MongoResultType, TimeFrameQueue<Long>> dbStaters =
                specStaters.computeIfAbsent(rulesStatDatabaseConfigName, x -> new HashMap<>());
            stater = new TimeFrameQueue<>(httpProxyServer.config().metricsTimeFrame());
            dbStaters.put(MongoResultType.OTHER, stater);
            httpProxyServer.registerStater(
                new PassiveStaterAdapter<>(
                    stater,
                    new DuplexStaterFactory<>(
                        new NamedStatsAggregatorFactory<>(
                            rulesStatDatabaseConfigName + "-time_ammm",
                            IntegralSumAggregatorFactory.INSTANCE),
                        new NamedStatsAggregatorFactory<>(
                            rulesStatDatabaseConfigName + "-total_ammm",
                            CountAggregatorFactory.INSTANCE))));
            for (MongoResultType errorType : MongoResultType.values()) {
                if (errorType == MongoResultType.OTHER) {
                    continue;
                }
                stater = new TimeFrameQueue<>(httpProxyServer.config().metricsTimeFrame());
                dbStaters.put(errorType, stater);
                httpProxyServer.registerStater(
                    new PassiveStaterAdapter<>(
                        stater,
                        new DuplexStaterFactory<>(
                            new NamedStatsAggregatorFactory<>(
                                rulesStatDatabaseConfigName + '-' + errorType.signalName() + "-time_ammm",
                                IntegralSumAggregatorFactory.INSTANCE),
                            new NamedStatsAggregatorFactory<>(
                                rulesStatDatabaseConfigName + '-' + errorType.signalName() + "-total_ammm",
                                CountAggregatorFactory.INSTANCE))));
            }
        }
    }
}
