package ru.yandex.mail.so.logger.config;

import java.io.IOException;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.mail.so.logger.Route;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;
import ru.yandex.stater.ImmutableStaterConfig;

public class ImmutableSpLoggerConfig extends ImmutableUniversalSearchProxyConfig implements SpLoggerConfig {
    private final ImmutableHttpHostConfig producerAsyncClientConfig;
    private final String deliveryLogPath;
    private final ImmutableLoggerConfig spareDeliveryLog;
    private final ImmutableLogStoragesConfig logStoragesConfig;
    private final ImmutableAuxiliaryStoragesConfig auxiliaryStoragesConfig;
    private final ImmutableLogRecordsHandlersConfig logRecordsHandlersConfig;
    private final ImmutableRulesStatDatabasesConfig rulesStatDatabasesConfig;
    private final String indexingQueueName;
    private final ImmutableStaterConfig indexSearchStaterConfig;
    private final long searchTimeout;
    private final int searchBackendShardsNumber;
    private final Route route;
    private final EnvironmentType envType;

    public ImmutableSpLoggerConfig(final SpLoggerConfig config) throws ConfigException, IOException {
        super(config);
        if (config.producerAsyncClientConfig() != null) {
            producerAsyncClientConfig = new ImmutableHttpHostConfig(config.producerAsyncClientConfig());
            indexingQueueName = config.indexingQueueName();
        } else {
            producerAsyncClientConfig = null;
            indexingQueueName = null;
        }

        if (producerClientConfig() == null) {
            throw new ConfigException("There are no parameters for producerClient in config");
        }
        deliveryLogPath = config.deliveryLogPath();
        spareDeliveryLog = new ImmutableLoggerConfig(config.spareDeliveryLog());
        logStoragesConfig = new ImmutableLogStoragesConfig(config.logStoragesConfig());
        auxiliaryStoragesConfig = new ImmutableAuxiliaryStoragesConfig(config.auxiliaryStoragesConfig());
        logRecordsHandlersConfig = new ImmutableLogRecordsHandlersConfig(config.logRecordsHandlersConfig());
        rulesStatDatabasesConfig = new ImmutableRulesStatDatabasesConfig(config.rulesStatDatabasesConfig());
        indexSearchStaterConfig = new ImmutableStaterConfig(config.indexSearchStaterConfig());
        searchTimeout = config.searchTimeout();
        searchBackendShardsNumber = config.searchBackendShardsNumber();
        route = config.route();
        envType = config.envType();
    }

    @Override
    public ImmutableHttpHostConfig producerAsyncClientConfig() {
        return producerAsyncClientConfig;
    }

    @Override
    public String deliveryLogPath() {
        return deliveryLogPath;
    }

    @Override
    public ImmutableLoggerConfig spareDeliveryLog() {
        return spareDeliveryLog;
    }

    @Override
    public ImmutableLogStoragesConfig logStoragesConfig() {
        return logStoragesConfig;
    }

    @Override
    public ImmutableAuxiliaryStoragesConfig auxiliaryStoragesConfig() {
        return auxiliaryStoragesConfig;
    }

    @Override
    public ImmutableLogRecordsHandlersConfig logRecordsHandlersConfig() {
        return logRecordsHandlersConfig;
    }

    @Override
    public ImmutableRulesStatDatabasesConfig rulesStatDatabasesConfig() {
        return rulesStatDatabasesConfig;
    }

    @Override
    public String indexingQueueName() {
        return indexingQueueName;
    }

    @Override
    public ImmutableStaterConfig indexSearchStaterConfig() {
        return indexSearchStaterConfig;
    }

    @Override
    public long searchTimeout() {
        return searchTimeout;
    }

    @Override
    public int searchBackendShardsNumber() {
        return searchBackendShardsNumber;
    }

    @Override
    public Route route() {
        return route;
    }

    @Override
    public EnvironmentType envType() {
        return envType;
    }
}
