package ru.yandex.mail.so.logger.config;

import java.util.List;

import ru.yandex.mail.so.logger.LogRecordsHandlerType;
import ru.yandex.mail.so.logger.Route;
import ru.yandex.stater.StaterConfig;

public interface LogRecordsHandlerConfig extends StaterConfig {
    /**
     * Get type of the log handler according to type of input delivery log: SP_DAEMON, NULL, etc.
     *
     * @return type of the log handler
     */
    LogRecordsHandlerType type();

    /**
     * Get config name for the related log storage
     *
     * @return config name for the related log storage
     */
    String logStorage();

    /**
     * Get TTL for saving of the log records by this log handler
     *
     * @return TTL for saving of the log records by this log handler
     */
    long storeTTL();

    /**
     * Get config name of the related database where rules statistics will be saved
     *
     * @return config name of the related database where rules statistics will be saved
     */
    String rulesStatDatabase();

    /**
     * Get decompression method for all log to be received by this log handler
     *
     * @return decompression method for all log to be received by this log handler
     */
    String decompression();

    /**
     * Get route which associated to all input log records for this log handler
     *
     * @return route which associated to all input log records for this log handler
     */
    Route route();

    /**
     * Get config names of auxiliary logs storages which will not be used for search data,
     * but for saving and separate processing of logs only
     *
     * @return config names of auxiliary logs storages
     */
    List<String> auxiliaryStorages();
}
