package ru.yandex.mail.so.logger.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class LogRecordsHandlerConfigBuilder
    extends AbstractLogRecordsHandlerConfigBuilder<LogRecordsHandlerConfigBuilder>
{
    public LogRecordsHandlerConfigBuilder() {
        super(LogRecordsHandlerConfigDefaults.INSTANCE);
    }

    public LogRecordsHandlerConfigBuilder(final LogRecordsHandlerConfig config) {
        super(config);
    }

    @SuppressWarnings("unused")
    public LogRecordsHandlerConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, LogRecordsHandlerConfigDefaults.INSTANCE);
    }

    public LogRecordsHandlerConfigBuilder(final IniConfig config, final LogRecordsHandlerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public LogRecordsHandlerConfigBuilder self() {
        return this;
    }

    public ImmutableLogRecordsHandlerConfig build() throws ConfigException {
        return new ImmutableLogRecordsHandlerConfig(this);
    }
}
