package ru.yandex.mail.so.logger.config;

import java.util.List;
import java.util.Locale;

import javax.annotation.Nonnull;

import ru.yandex.mail.so.logger.LogRecordsHandlerType;
import ru.yandex.mail.so.logger.Route;
import ru.yandex.stater.StaterConfigDefaults;

public class LogRecordsHandlerConfigDefaults extends StaterConfigDefaults implements LogRecordsHandlerConfig {
    public static final LogRecordsHandlerConfigDefaults INSTANCE = new LogRecordsHandlerConfigDefaults();

    protected LogRecordsHandlerConfigDefaults() {
    }

    @Nonnull
    @Override
    public LogRecordsHandlerType type() {
        return LogRecordsHandlerType.NULL;
    }

    @Override
    public String logStorage() {
        return null;
    }

    @Override
    public long storeTTL() {
        return 0L;
    }

    @Override
    public String rulesStatDatabase() {
        return null;
    }

    @Override
    public String decompression() {
        return "raw";
    }

    @Override
    public Route route() {
        return null;
    }

    @Override
    public String prefix() {
        return type().name().toLowerCase(Locale.ROOT).replace('_', '-');
    }

    @Override
    public List<String> auxiliaryStorages() {
        return List.of();
    }
}
