package ru.yandex.mail.so.logger.config;

import ru.yandex.mail.so.logger.LogRecordContext;
import ru.yandex.mail.so.logger.LogStorage;
import ru.yandex.mail.so.logger.LogStorageException;
import ru.yandex.mail.so.logger.LogStorageType;
import ru.yandex.mail.so.logger.SpLogger;

public interface LogStorageConfig extends BatchSaverConfig {
    /**
     * Creates log storage object that encapsulates all functionality for data saving to and retrieving from it
     *
     * @param spLogger SpLogger server within which new storage will be registered
     * @param name config name of the storage
     * @return the log storage object that encapsulates all functionality for data saving to and retrieving from it
     * @throws LogStorageException exception that me be thrown while creation of the storage object
     */
    LogStorage<LogRecordContext> createStorage(final SpLogger spLogger, final String name) throws LogStorageException;

    /**
     * Get type of the log storage
     *
     * @return type of the log storage
     */
    @Override
    LogStorageType type();

    /**
     * Get TTL for the data to be saved
     *
     * @return TTL for the data to be saved
     */
    long storeTTL();

    /**
     * Get max size of the batch (number of log records)
     *
     * @return max size of the batch (number of log records)
     */
    long batchMaxSize();

    /**
     * Get max size of the batch in bytes after exceeding which the batch will start saving
     *
     * @return max size of the batch in bytes after exceeding which the batch will start saving
     */
    long batchesMemoryLimit();

    /**
     * Get max batches per second after exceeding which saving of the batch will be postponed
     *
     * @return max batches per second after exceeding which saving of the batch will be postponed
     */
    double batchSaveMaxRps();

    /**
     * Get number of attempts to save given batch into the search index
     *
     * @return number of attempts to save given batch into the search index
     */
    int indexRetriesCount();
}
