package ru.yandex.mail.so.logger.config;

import java.util.List;

import ru.yandex.mail.so.logger.BatchLogSaver;
import ru.yandex.mail.so.logger.LogRecordsHandlerType;
import ru.yandex.mail.so.logger.Route;
import ru.yandex.stater.StaterConfigDefaults;

public class NullLogRecordsHandlerConfig extends StaterConfigDefaults implements LogRecordsHandlerConfig {
    public static final NullLogRecordsHandlerConfig INSTANCE = new NullLogRecordsHandlerConfig();

    @Override
    public LogRecordsHandlerType type() {
        return LogRecordsHandlerType.NULL;
    }

    @Override
    public String logStorage() {
        return BatchLogSaver.NULL;
    }

    @Override
    public long storeTTL() {
        return 0L;
    }

    @Override
    public List<String> auxiliaryStorages() {
        return null;
    }

    @Override
    public String rulesStatDatabase() {
        return null;
    }

    @Override
    public String decompression() {
        return null;
    }

    @Override
    public Route route() {
        return null;
    }
}
