package ru.yandex.mail.so.logger.config;

import ru.yandex.mail.so.logger.LogRecordContext;
import ru.yandex.mail.so.logger.LogStorage;
import ru.yandex.mail.so.logger.LogStorageException;
import ru.yandex.mail.so.logger.LogStorageType;
import ru.yandex.mail.so.logger.NullLogStorage;
import ru.yandex.mail.so.logger.SpLogger;

public class NullLogStorageConfig implements LogStorageConfig {
    public static final NullLogStorageConfig INSTANCE = new NullLogStorageConfig();

    @Override
    public String name() {
        return null;
    }

    @Override
    public LogStorageType type() {
        return LogStorageType.NULL;
    }

    @Override
    public int workers() {
        return 1;
    }

    @Override
    public LogStorage<LogRecordContext> createStorage(final SpLogger spLogger, final String name)
        throws LogStorageException
    {
        return new NullLogStorage(spLogger, name);
    }

    @Override
    public long storeTTL() {
        return 0L;
    }

    @Override
    public long batchMinSize() {
        return 0L;
    }

    @Override
    public long batchMaxSize() {
        return 102400L;
    }

    @Override
    public long batchesMemoryLimit() {
        return 1073741824L;
    }

    @Override
    public double batchSaveMaxRps() {
        return -1d;
    }

    @Override
    public long batchSavePeriod() {
        return 3000L;
    }

    @Override
    public long batchSaveRetryTimeout() {
        return 5000L;
    }

    @Override
    public int batchSaveRetries() {
        return 3;
    }

    @Override
    public int indexRetriesCount() {
        return 3;
    }

    @Override
    public long savingOperationTimeout() {
        return 3000L;
    }
}
