package ru.yandex.mail.so.logger.config;

import ru.yandex.http.config.ClientHttpsConfig;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.mail.so.logger.BasicRoutedLogRecordProducer;
import ru.yandex.mail.so.logger.NullRulesStatDatabase;
import ru.yandex.mail.so.logger.RulesStatDatabase;
import ru.yandex.mail.so.logger.RulesStatDatabaseType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class NullRulesStatDatabaseConfig extends AbstractRulesStatDatabaseConfig<BasicRoutedLogRecordProducer>
{
    public static final NullRulesStatDatabaseConfig INSTANCE = new NullRulesStatDatabaseConfig();

    NullRulesStatDatabaseConfig() {
        super();
    }

    public NullRulesStatDatabaseConfig(
        final IniConfig config,
        final String configName,
        final RulesStatDatabaseConfig<BasicRoutedLogRecordProducer> defaults)
        throws ConfigException
    {
        super(config, configName, defaults);
    }

    @Override
    public RulesStatDatabaseType type() {
        return RulesStatDatabaseType.NULL;
    }

    @Override
    public RulesStatDatabase<BasicRoutedLogRecordProducer> createClient(
        final HttpProxy<?> httpProxy,
        final RulesStatDatabasesOperatorConfig<BasicRoutedLogRecordProducer> rulesStatDatabasesOperatorConfig,
        final String name)
    {
        return new NullRulesStatDatabase<>(httpProxy, name);
    }

    @Override
    public ClientHttpsConfig sslConfig() {
        return null;
    }

    @Override
    protected void parseDatabaseConfig(
        final IniConfig config,
        final RulesStatDatabaseConfig<BasicRoutedLogRecordProducer> defaults)
        throws ConfigException
    {
    }

    @Override
    public long batchMinSize() {
        return 0L;
    }

    @Override
    public long batchSavePeriod() {
        return 60000L;
    }

    @Override
    public int batchSaveRetries() {
        return 0;
    }

    @Override
    public long batchSaveRetryTimeout() {
        return 120000L;
    }

    @Override
    public int workers() {
        return 1;
    }

    @Override
    public long savingOperationTimeout() {
        return 30000L;
    }
}
