package ru.yandex.mail.so.logger.config;

import java.util.List;

import ru.yandex.http.config.ClientHttpsConfig;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.mail.so.logger.RoutedLogRecordProducer;
import ru.yandex.mail.so.logger.RulesStatDatabase;
import ru.yandex.mail.so.logger.RulesStatDatabaseType;

public interface RulesStatDatabaseConfig<P extends RoutedLogRecordProducer> extends BatchSaverConfig {
    /**
     * Get type of database: MONGODB, PG, NULL, etc.
     *
     * @return type of database
     */
    @Override
    RulesStatDatabaseType type();

    /**
     * Creates rules statistics related database's client
     *
     * @param httpProxy server where the new client will be registered
     * @param rulesStatDatabasesOperatorConfig config for rules statistics related databases operators
     * @param name config name for the given client to be created
     * @return rules statistics related database's client
     */
    RulesStatDatabase<P> createClient(
        final HttpProxy<?> httpProxy,
        final RulesStatDatabasesOperatorConfig<P> rulesStatDatabasesOperatorConfig,
        final String name);

    /**
     * Get the list of the hosts of the database's replicas
     *
     * @return list of the hosts of the database's replicas
     */
    List<? extends HttpHostConfig> hosts();

    /**
     * Get port for the database (assume it's the same for all replicas)
     *
     * @return port for the database
     */
    int port();

    /**
     * Get database's name
     *
     * @return database's name
     */
    String dbName();

    /**
     * Get user's name for database's connection
     *
     * @return user's name for database's connection
     */
    String userName();

    /**
     * Get password for database's connection
     *
     * @return password for database's connection
     */
    String secret();

    /**
     * Get SSL/TLS config for database's connection
     *
     * @return SSL/TLS config for database's connection
     */
    ClientHttpsConfig sslConfig();
}
