package ru.yandex.mail.so.logger.config;

import java.util.Map;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.mail.so.logger.MongoResultType;
import ru.yandex.mail.so.logger.RoutedLogRecordProducer;

public interface RulesStatDatabasesConfig<P extends RoutedLogRecordProducer> {
    /**
     * Get configs for operations with rules statistics related databases according to its config names
     *
     * @return configs for operations with rules statistics related databases according to its config names
     */
    Map<String, ? extends RulesStatDatabaseConfig<P>> rulesStatDatabases();

    /**
     * Get special staters related to operations with rules statistics databases
     *
     * @return special staters related to operations with rules statistics databases
     */
    Map<String, Map<MongoResultType, TimeFrameQueue<Long>>> specStaters();

    /**
     * Cock the signal for the given config name and mongodb client's result type
     *
     * @param rulesStatDatabaseConfigName config name that identifies the mongodb's client
     * @param errorType mongodb client's result type
     * @param duration duration of the related operation with mongodb's client
     */
    default void stat(final String rulesStatDatabaseConfigName, final MongoResultType errorType, final long duration) {
        System.err.println("RulesStatDatabasesConfig.stat: configName=" + rulesStatDatabaseConfigName + ", error="
            + errorType.signalName() + ", duration=" + duration);
        specStaters().get(rulesStatDatabaseConfigName).get(errorType).accept(duration);
        if (errorType != MongoResultType.OTHER) {
            specStaters().get(rulesStatDatabaseConfigName).get(MongoResultType.OTHER).accept(duration);
        }
    }
}
