package ru.yandex.mail.so.logger.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.mail.so.logger.BasicRoutedLogRecordProducer;
import ru.yandex.mail.so.logger.Route;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfig;
import ru.yandex.stater.StaterConfig;

public interface SpLoggerConfig
    extends UniversalSearchProxyConfig, RulesStatDatabasesOperatorConfig<BasicRoutedLogRecordProducer>
{
    /**
     * Get route of mail processing
     *
     * @return route of mail processing
     */
    Route route();

    /**
     * Get name of indexation queue
     *
     * @return name of indexation queue
     */
    String indexingQueueName();

    /**
     * Get number of shards in the search backend
     *
     * @return number of shards in the search backend
     */
    int searchBackendShardsNumber();

    /**
     * Get timeout for search requests
     *
     * @return timeout for search requests
     */
    long searchTimeout();

    /**
     * Get config for staters of search backend's index
     *
     * @return config for staters of search backend's index
     */
    StaterConfig indexSearchStaterConfig();

    /**
     * Get config for the producer's async clients
     *
     * @return config for the producer's async clients
     */
    HttpHostConfig producerAsyncClientConfig();

    /**
     * Get config for logs records handlers
     *
     * @return config for logs records handlers
     */
    LogRecordsHandlersConfig logRecordsHandlersConfig();

    /**
     * Get config for logs records' storages
     *
     * @return config for logs records' storages
     */
    LogStoragesConfig logStoragesConfig();

    /**
     * Get config for auxiliary storages of logs records
     *
     * @return config for auxiliary storages of logs records
     */
    AuxiliaryStoragesConfig auxiliaryStoragesConfig();

    /**
     * Get path to delivery log which failed to be send to sp-logger
     *
     * @return path to delivery log which failed to be send to sp-logger
     */
    String deliveryLogPath();

    /**
     * Get logger's config for saving delivery log, which failed to be processed, to spare local file
     *
     * @return logger's config for saving delivery log, which failed to be processed, to spare local file
     */
    LoggerConfig spareDeliveryLog();
}
