package ru.yandex.mail.so.logger.config;

import java.io.IOException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class SpLoggerConfigBuilder
    extends AbstractSpLoggerConfigBuilder<SpLoggerConfigBuilder> implements SpLoggerConfig
{
    public SpLoggerConfigBuilder() {
        super(SpLoggerConfigDefaults.INSTANCE);
    }

    public SpLoggerConfigBuilder(final SpLoggerConfig config) {
        super(config);
    }

    public SpLoggerConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, SpLoggerConfigDefaults.INSTANCE);
    }

    public SpLoggerConfigBuilder(final IniConfig config, final SpLoggerConfig defaults) throws ConfigException {
        super(config, defaults);
    }

    @Override
    public SpLoggerConfigBuilder self() {
        return this;
    }

    public ImmutableSpLoggerConfig build() throws ConfigException, IOException {
        return new ImmutableSpLoggerConfig(this);
    }
}
