package ru.yandex.mail.so.logger.config;

import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigDefaults;
import ru.yandex.mail.so.logger.BasicRoutedLogRecordProducer;
import ru.yandex.mail.so.logger.Route;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;
import ru.yandex.stater.StaterConfig;
import ru.yandex.stater.StaterConfigDefaults;

public class SpLoggerConfigDefaults extends UniversalSearchProxyConfigDefaults implements SpLoggerConfig {
    public static final SpLoggerConfigDefaults INSTANCE = new SpLoggerConfigDefaults();

    protected SpLoggerConfigDefaults() {
    }

    @Override
    public HttpHostConfigDefaults producerAsyncClientConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public String deliveryLogPath() {
        return null;
    }

    @Override
    public LoggerConfig spareDeliveryLog() {
        return LoggerConfigDefaults.INSTANCE;
    }

    @Override
    public LogStoragesConfig logStoragesConfig() {
        return LogStoragesConfigDefaults.INSTANCE;
    }

    @Override
    public AuxiliaryStoragesConfig auxiliaryStoragesConfig() {
        return AuxiliaryStoragesConfigDefaults.INSTANCE;
    }

    @Override
    public LogRecordsHandlersConfig logRecordsHandlersConfig() {
        return LogRecordsHandlersConfigDefaults.INSTANCE;
    }

    @Override
    public RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> rulesStatDatabasesConfig() {
        return RulesStatDatabasesConfigDefaults.INSTANCE;
    }

    @Override
    public String indexingQueueName() {
        return null;
    }

    @Override
    public StaterConfig indexSearchStaterConfig() {
        return StaterConfigDefaults.INSTANCE;
    }

    @Override
    public long searchTimeout() {
        return 100L;
    }

    @Override
    public int searchBackendShardsNumber() {
        return 14;
    }

    @Override
    public Route route() {
        return null;
    }

    @Override
    public EnvironmentType envType() {
        return EnvironmentType.PRODUCTION;
    }

    @Override
    public String name() {
        return "SpLogger";
    }
}
