JAVA_LIBRARY(sp-logger)

JDK_VERSION(11)

OWNER(g:so)

INCLUDE(${ARCADIA_ROOT}/mail/persdata/build/stricter_java_check.inc)

JAVA_SRCS(SRCDIR main/java **/*.java)

PEERDIR(
    contrib/java/org/mongodb/mongodb-driver-reactivestreams/4.4.0
    contrib/java/org/postgresql/postgresql/42.2.18
    mail/contrib/httpcomponents/httpclient/httpmime
    mail/so/libs/java/data_compressor
    mail/search/mail/mail_document
    mail/search/universal_search_proxy
)

EXCLUDE(contrib/java/org/reactivestreams/reactive-streams/1.0.2)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/mail/tools/templates/classpath.template.sh
    OUT ${BINDIR}/classpath.sh
    CUSTOM_PROPERTY packageName sp-logger
)

END()

IF (OS_LINUX AND SANITIZER_TYPE != "memory" AND SANITIZER_TYPE != "undefined")
    RECURSE_FOR_TESTS(
        test_base
#        test_in_yt
    )
ENDIF()

RECURSE(
    libs/crypto
    libs/curl
    test_in_yt
)
