#!/bin/bash
set -x

source config.sh

PORTO_NAME=$(portoctl get self absolute_name)
SP_LOGGER_CONTAINER=${PORTO_NAME}/sp-daemon/sp-logger

function log() {
    echo $(date '+%Y-%m-%d %H:%M:%S.%3N')' '$*
}

log "Starting porter in progress"

prevPid=-1
while true; do
    pid=$(cat pids/sp-daemon)
    if [ -z "$pid" ]; then
        log "Waiting for sp-daemon"
        sleep 1
        continue
    elif [ "$prevPid" != "$pid" ]; then
        log "Starting porting operation"
        pidSpLogger=$(cat pids/sp-logger)
        portoctl attach -t ${SP_LOGGER_CONTAINER} $pidSpLogger || true
        log "Porting operation DONE"
        prevPid=$pid
    fi
done

