package ru.yandex.mail.so.logger;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.regex.Matcher;

import ru.yandex.collection.Pattern;
import ru.yandex.function.GenericBiConsumer;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.server.DefaultHttpServerFactory;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.logger.HandlersManager;
import ru.yandex.mail.so.logger.config.ImmutableSpLoggerConsumerConfig;
import ru.yandex.mail.so.logger.config.ImmutableStoreLogHandlerConfig;
import ru.yandex.mail.so.logger.config.RulesStatDatabasesConfig;
import ru.yandex.parser.config.ConfigException;

public class SpLoggerConsumer
    extends HttpProxy<ImmutableSpLoggerConsumerConfig>
    implements RulesStatDatabasesOperator<BasicRoutedLogRecordProducer>
{
    //private static final String SERVER_HOSTNAME = serverHostname();
    //private static final String LOCALHOST = "localhost";
    private static final String YP_DOMAIN = ".yp-c.yandex.net";
    private static final java.util.regex.Pattern YP_ID_DC = java.util.regex.Pattern.compile("-([a-z]{3})-\\d+$");

    private final Map<String, RulesStatDatabase<BasicRoutedLogRecordProducer>> rulesStatDatabases;
    private final HandlersManager handlersManager;


    public SpLoggerConsumer(final ImmutableSpLoggerConsumerConfig config) throws ConfigException, IOException
    {
        super(config);
        System.setProperty("java.version", "16");   // stupid patch for successful running of mongodb java driver
        handlersManager = new HandlersManager();
        rulesStatDatabases = prepareClients(config, this);
        config.rulesStatDatabasesConfig().registerComponents(this);
        logger.info("SpLoggerConsumer: rulesStatDatabases = " + rulesStatDatabases);
        config.storeLogHandlersConfig().storeLogHandlers().traverse(new StoreLogHandlerVisitor());
    }

    @Override
    public void start() throws IOException {
        for (RulesStatDatabase<BasicRoutedLogRecordProducer> rulesStatDatabase : rulesStatDatabases.values()) {
            rulesStatDatabase.start();
            closeChain.add(rulesStatDatabase);
        }
        super.start();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> rulesStatDatabasesConfig() {
        return config.rulesStatDatabasesConfig();
    }

    @Override
    public Map<String, RulesStatDatabase<BasicRoutedLogRecordProducer>> rulesStatDatabases() {
        return rulesStatDatabases;
    }

    public HandlersManager handlersManager() {
        return handlersManager;
    }

    @SuppressWarnings("unused")
    private static String serverHostname() {
        String hostname = System.getProperty("YP_POD_ID");
        if (hostname != null) {
            String dc = System.getProperty("a_dc");
            if (dc == null || dc.equals("msk")) {
                Matcher yp = YP_ID_DC.matcher(hostname);
                if (yp.find()) {
                    return hostname + '.' + yp.group(1) + YP_DOMAIN;
                }
            } else {
                return hostname + '.' + dc + YP_DOMAIN;
            }
        }
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            } catch (UnknownHostException ue) {
                hostname = "unknown";
            }
        }
        return hostname;
    }

    private class StoreLogHandlerVisitor
        implements GenericBiConsumer<Pattern<RequestInfo>, ImmutableStoreLogHandlerConfig, ConfigException>
    {
        @Override
        public void accept(final Pattern<RequestInfo> pattern, final ImmutableStoreLogHandlerConfig config)
            throws ConfigException
        {
            logger().info("Registering of store log handler for path " + pattern.path());
            StoreLogsHandler handler = new StoreLogsHandler(config, SpLoggerConsumer.this, pattern.path());
            register(pattern, handler, RequestHandlerMapper.POST);
        }
    }

    @SuppressWarnings("unused")
    public static void main(final String... args) {
        try {
            HttpServer<?, ?> spLoggerConsumer =
                SpLoggerConsumer.main(
                    new DefaultHttpServerFactory<>(SpLoggerConsumer.class),
                    args[0]);
        } catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }
}
