package ru.yandex.mail.so.logger.config;

import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.mail.so.logger.BasicRoutedLogRecordProducer;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractSpLoggerConsumerConfigBuilder<T extends AbstractSpLoggerConsumerConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T> implements SpLoggerConsumerConfig
{
    private EnvironmentType envType;
    private StoreLogHandlersConfigBuilder storeLogHandlersConfig;
    private RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> rulesStatDatabasesConfig;

    protected AbstractSpLoggerConsumerConfigBuilder(final SpLoggerConsumerConfig config) {
        super(config);
        envType(config.envType());
        storeLogHandlersConfig(config.storeLogHandlersConfig());
        rulesStatDatabasesConfig(config.rulesStatDatabasesConfig());
    }

    protected AbstractSpLoggerConsumerConfigBuilder(final IniConfig config, final SpLoggerConsumerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        IniConfig spLoggerConsumerConfig = config.section("sp-logger-consumer");
        envType = spLoggerConsumerConfig.get("env-type", defaults.envType(), new EnvironmentType.Parser());
        storeLogHandlersConfig = new StoreLogHandlersConfigBuilder(
            config.section(StoreLogHandlersConfigBuilder.SECTION),
            defaults.storeLogHandlersConfig());
        rulesStatDatabasesConfig =
            new RulesStatDatabasesConfigBuilder(
                config.section(RulesStatDatabasesConfigBuilder.SECTION),
                defaults.rulesStatDatabasesConfig());
    }

    @Override
    public EnvironmentType envType() {
        return envType;
    }

    public T envType(final EnvironmentType envType) {
        this.envType = envType;
        return self();
    }

    @Override
    public StoreLogHandlersConfigBuilder storeLogHandlersConfig() {
        return storeLogHandlersConfig;
    }

    public T storeLogHandlersConfig(final StoreLogHandlersConfig storeLogHandlersConfig) {
        this.storeLogHandlersConfig = new StoreLogHandlersConfigBuilder(storeLogHandlersConfig);
        return self();
    }

    @Override
    public RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> rulesStatDatabasesConfig() {
        return rulesStatDatabasesConfig;
    }

    public T rulesStatDatabasesConfig(
        final RulesStatDatabasesConfig<BasicRoutedLogRecordProducer> rulesStatDatabasesConfig)
    {
        this.rulesStatDatabasesConfig = new RulesStatDatabasesConfigBuilder(rulesStatDatabasesConfig);
        return self();
    }
}
